
# Catalog Image

An image file to use in Square catalogs. It can be associated with catalog
items, item variations, and categories.

## Structure

`CatalogImage`

## Fields

| Name | Type | Tags | Description | Getter | Setter |
|  --- | --- | --- | --- | --- | --- |
| `name` | `?string` | Optional | The internal name to identify this image in calls to the Square API.<br>This is a searchable attribute for use in applicable query filters<br>using the [SearchCatalogObjects](/doc/apis/catalog.md#search-catalog-objects).<br>It is not unique and should not be shown in a buyer facing context. | getName(): ?string | setName(?string name): void |
| `url` | `?string` | Optional | The URL of this image, generated by Square after an image is uploaded<br>using the [CreateCatalogImage](/doc/apis/catalog.md#create-catalog-image) endpoint. | getUrl(): ?string | setUrl(?string url): void |
| `caption` | `?string` | Optional | A caption that describes what is shown in the image. Displayed in the<br>Square Online Store. This is a searchable attribute for use in applicable query filters<br>using the [SearchCatalogObjects](/doc/apis/catalog.md#search-catalog-objects). | getCaption(): ?string | setCaption(?string caption): void |

## Example (as JSON)

```json
{
  "name": "name0",
  "url": "url4",
  "caption": "caption4"
}
```

