<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if(Schema::hasTable('settings')){

            Schema::table('settings', function (Blueprint $table) {
                if (!Schema::hasColumn('settings', 'currency')) {
                    $table->string('currency')->default('USD')->nullable();
                }
                if (!Schema::hasColumn('settings', 'currency_symbol')) {
                    $table->string('currency_symbol')->default('$')->nullable();
                }
                if (!Schema::hasColumn('settings', 'cookie_message')) {
                    $table->string('cookie_message')->default('Welcome to our site. Please accept cookies for a better experience.')->nullable();
                }
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('settings', function (Blueprint $table) {
            $table->dropColumn(['currency', 'currency_symbol']);
        });
    }
};
