<?php

namespace App\Http\Middleware;

use Closure;

class IsInstalled
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        // Skip check for installation routes
        if ($request->is('db*') || $request->is('server*') || $request->is('install*')) {
            return $next($request);
        }
    
        if (env('IS_INSTALLED') == 0) {
            return redirect('db');
        }
    
        return $next($request);
    }
}
